
USE SZAMLAK
GO

CREATE TABLE [AFA] (
	[AKOD] [char] (1) COLLATE Hungarian_CI_AS NOT NULL ,
	[NAFA] [smallint] NOT NULL ,
	[SZAFA] [varchar] (6) COLLATE Hungarian_CI_AS NOT NULL ,
	CONSTRAINT [PK_AFA] PRIMARY KEY  CLUSTERED 
	(
		[AKOD]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO

USE SZAMLAK
GO

CREATE TABLE [ME] (
	[SORSZ] [char] (2) COLLATE Hungarian_CI_AS NOT NULL ,
	[MEGYS] [varchar] (6) COLLATE Hungarian_CI_AS NULL ,
	CONSTRAINT [PK_ME] PRIMARY KEY  CLUSTERED 
	(
		[SORSZ]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO

USE SZAMLAK
GO

CREATE TABLE [PARTNER] (
	[PKOD] [char] (4) COLLATE Hungarian_CI_AS NOT NULL ,
	[PNEV] [varchar] (25) COLLATE Hungarian_CI_AS NOT NULL ,
	[PTIPUS] [char] (1) COLLATE Hungarian_CI_AS NOT NULL ,
	[PIRSZ] [char] (4) COLLATE Hungarian_CI_AS NULL ,
	[PTELEP] [varchar] (20) COLLATE Hungarian_CI_AS NOT NULL ,
	[PUTCA] [varchar] (30) COLLATE Hungarian_CI_AS NULL ,
	[PKAPCS] [varchar] (25) COLLATE Hungarian_CI_AS NULL ,
	[PKTEL] [varchar] (9) COLLATE Hungarian_CI_AS NULL ,
	CONSTRAINT [PK_PARTNER] PRIMARY KEY  CLUSTERED 
	(
		[PKOD]
	)  ON [PRIMARY] 
) ON [PRIMARY]
GO

USE SZAMLAK
GO

CREATE TABLE [SZLATRZS] (
	[SZAZON] [char] (6) COLLATE Hungarian_CI_AS NOT NULL ,
	[SZDAT] [smalldatetime] NOT NULL ,
	[SZSZAM] [char] (8) COLLATE Hungarian_CI_AS NOT NULL ,
	[SZTIP] [char] (1) COLLATE Hungarian_CI_AS NOT NULL ,
	[PKOD] [char] (4) COLLATE Hungarian_CI_AS NOT NULL ,
	[SZFIZMOD] [char] (1) COLLATE Hungarian_CI_AS NOT NULL ,
	[SZEGYEB] [varchar] (200) COLLATE Hungarian_CI_AS NULL ,
	[TETELDB] [tinyint] NULL ,
	CONSTRAINT [PK_SZLATRZS] PRIMARY KEY  CLUSTERED 
	(
		[SZAZON]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_SZLATRZS_PARTNER] FOREIGN KEY 
	(
		[PKOD]
	) REFERENCES [PARTNER] (
		[PKOD]
	)
) ON [PRIMARY]
GO

USE SZAMLAK
GO

CREATE TABLE [SZLARSZL] (
	[SZAZON] [char] (6) COLLATE Hungarian_CI_AS NOT NULL ,
	[TSORSZ] [char] (2) COLLATE Hungarian_CI_AS NOT NULL ,
	[TITJSZJ] [char] (15) COLLATE Hungarian_CI_AS NOT NULL ,
	[TMEGN] [varchar] (50) COLLATE Hungarian_CI_AS NOT NULL ,
	[TME] [char] (2) COLLATE Hungarian_CI_AS NOT NULL ,
	[TMENNY] [decimal](11, 2) NOT NULL ,
	[TEAR] [decimal](10, 2) NOT NULL ,
	[TSZAZAL] [char] (1) COLLATE Hungarian_CI_AS NOT NULL ,
	[TENGSZ] [tinyint] NULL ,
	CONSTRAINT [PK_SZLARSZL] PRIMARY KEY  CLUSTERED 
	(
		[SZAZON],
		[TSORSZ]
	)  ON [PRIMARY] ,
	CONSTRAINT [FK_SZLARSZL_AFA] FOREIGN KEY 
	(
		[TSZAZAL]
	) REFERENCES [AFA] (
		[AKOD]
	),
	CONSTRAINT [FK_SZLARSZL_ME] FOREIGN KEY 
	(
		[TME]
	) REFERENCES [ME] (
		[SORSZ]
	),
	CONSTRAINT [FK_SZLARSZL_SZLATRZS] FOREIGN KEY 
	(
		[SZAZON]
	) REFERENCES [SZLATRZS] (
		[SZAZON]
	)
) ON [PRIMARY]
GO




